<?php
//namespace wp-content\plugins\screenreader;  
/** 
 * Main wp install and render plugin
 * @package SCREENREADER::plugins
 * @author JExtensions Store 
 * @copyright (C) 2016 - JExtensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */

/*
 Plugin Name: Screen Reader
 Plugin URI: https://storejextensions.org/extensions/screen_reader.html
 Description: Screen Reader with FontSize & HighContrast for Wordpress is an advanced and lightweight plugin that will add accessibility features.
 Author: JExtensions Store
 Version: 3.28
 Author URI: https://storejextensions.org
*/

// SITE SECTION OUTPUT SCRIPTS
function screenreader() { 
	global $wpdb, $table_prefix;
	// CONFIG LOAD DA DB OPTIONS
	$screenreaderQuery = "SELECT * FROM " . $table_prefix . "screenreader_config";
	$pparams = $wpdb->get_row($screenreaderQuery);
	
	$siteUrl = plugins_url('/', __FILE__);
	$langTag = get_bloginfo ( 'language' );
	
	if($pparams->sef_lang_code) {
		$explodedLangTag = explode ( '-', $langTag );
		$langCode = array_shift ( $explodedLangTag );
	} else {
		$langCode = $langTag;
	}
		
	$token = md5 ( $_SERVER ["HTTP_HOST"] );
	
	// Security safe
	if($langTag == 'el') {
		$langTag = 'el-GR';
	}
	
	// Security safe
	if (! file_exists( dirname(__FILE__) . '/languages/' . $langTag . '.js' )) {
		$langTag = 'en-GB';
	}
	
	// Ensure that the chunk length is correct for Responsive Voice Greek
	if($pparams->reader_engine == 'proxy_responsive' && $langTag == 'el-GR' && $pparams->chunksize > 200) {
		$pparams->chunksize = 200;
	}
	
	// Ensure that the chunk length is correct for Google
	if($pparams->reader_engine == 'proxy' && $pparams->chunksize > 100) {
		$pparams->chunksize = 100;
	}
	
	// Ensure that the chunk length is correct for ISpeech
	if($pparams->reader_engine == 'proxy_ispeech' && $pparams->chunksize > 90) {
		$pparams->chunksize = 90;
	}
		
	// Ensure that the chunk length is correct for Virtual Readers
	if($pparams->reader_engine == 'proxy_virtual_free') {
		if($pparams->chunksize >= 300) {
			$pparams->chunksize = 280;
		}
		$pparams->preload = 1;
	}
	
	// Override params for texttomp3 optimization
	if(($pparams->reader_engine == 'proxy_texttomp3')) {
		$pparams->chunksize = 300;
		$pparams->preload = 1;
	}
	
	// Override params for neospeech optimization
	if(($pparams->reader_engine == 'proxy_neospeech')) {
		if($pparams->chunksize < 400) {
			$pparams->chunksize = 400;
		}
		$pparams->preload = 1;
	}
	
	echo '<link type="text/css" href="' . $siteUrl . 'libraries/controller/css/' . $pparams->template . '" rel="stylesheet" charset="utf-8"/>'; 
	
	// Load jQuery in safe way
	if($pparams->jquery_include) {
		wp_enqueue_script('jquery');
		if($pparams->force_jquery_deferred) {
			echo '<script type="text/javascript" src="' . $siteUrl . 'libraries/jquery/jquery.js" charset="utf-8" defer></script>';
		}
	}
	
	$scriptDeferLoading = $pparams->script_loading == 'deferred' ? 'defer="defer"' : null;
	
	echo '<script type="text/javascript" src="' . $siteUrl . 'languages/' . $langTag . '.js" charset="utf-8"></script>';
	echo '<script type="text/javascript" src="' . $siteUrl . 'libraries/tts/soundmanager/soundmanager2.js" charset="utf-8"></script>';
	echo '<script type="text/javascript" src="' . $siteUrl . 'libraries/tts/tts.js" charset="utf-8" ' . $scriptDeferLoading . '></script>';
	echo '<script type="text/javascript" src="' . $siteUrl . 'libraries/controller/controller.js" charset="utf-8" ' . $scriptDeferLoading . '></script>';

	$pparams->proxy_responsive_apikey = trim($pparams->proxy_responsive_apikey) ? trim($pparams->proxy_responsive_apikey) : 'YkiNlVQr';
	if($pparams->reader_engine == 'proxy_responsive' || ($pparams->use_mobile_reader_engine && $pparams->mobile_reader_engine == 'proxy_responsive')) {
		if($pparams->proxy_responsive_loading_script == 0) {
			echo '<script type="text/javascript" src="' . $siteUrl . 'libraries/tts/responsivevoice.js" charset="utf-8" ' . $scriptDeferLoading . '></script>';
		}else {
			echo '<script type="text/javascript" src="https://code.responsivevoice.org/responsivevoice.js?key=' . $pparams->proxy_responsive_apikey . '" charset="utf-8" ' . $scriptDeferLoading . '></script>';
		}
	}
	
	echo ("<style type='text/css'>#accessibility-links #text_plugin{width:" . (int)$pparams->labelwidth . "px;}</style>");
	
	// Add focusable outline if enabled
	if($pparams->enable_focus_outline) {
		echo ("<style type='text/css'>:focus{outline: $pparams->enable_focus_outline_bordersize solid $pparams->enable_focus_outline_color !important;}</style>");
	}
	
	if($toolbarBorderRadius = (int)$pparams->toolbar_border_radius) {
		echo ("<style type='text/css'>div#accessibility-links,div#accessibility-links.bottomleft,div#accessibility-links.topleft,div#accessibility-links.bottomright,div#accessibility-links.topright,div#tts_message,div#accessibility-links div#msgtext,div#accessibility-links div#playicon{border-radius:" . $toolbarBorderRadius . "px;}</style>");
	}
	
	$jsInject = <<<JS
	<script type="text/javascript">
		window.soundManager.url = '{$siteUrl}libraries/tts/soundmanager/swf/';
		window.soundManager.debugMode = false;
		window.soundManager.defaultOptions.volume = $pparams->volume_tts;
	
		var screenReaderConfigOptions = {	baseURI: '$siteUrl',
											token: '$token',
											langCode: '$langCode',
											chunkLength: $pparams->chunksize,
											gtranslateIntegration: $pparams->gtranslateintegration,
											screenReaderVolume: '$pparams->volume_tts',
											screenReaderVoiceSpeed: '$pparams->voice_speed',
											position: '$pparams->corner_position',
											scrolling: '$pparams->scrolling',
											targetAppendto: '$pparams->target_appendto',
											targetAppendMode: '$pparams->target_append_mode',
											preload: $pparams->preload,
											autoBackgroundColor: $pparams->auto_background_color,
											readPage: $pparams->read_page,
											readChildNodes: $pparams->read_child_nodes,
											ieHighContrast: $pparams->ie_highcontrast,
											ieHighContrastAdvanced: $pparams->ie_highcontrast_advanced,
											selectedStorage: '$pparams->selected_storage',
											selectMainpageareaText: $pparams->select_mainpagearea_text,
											excludeScripts: $pparams->exclude_scripts,
											readImages: $pparams->read_images,
											readImagesAttribute: '$pparams->read_images_attribute',
											readImagesOrdering: '$pparams->read_images_ordering',
											readImagesHovering: $pparams->read_images_hovering,
											mainpageSelector: '$pparams->mainpage_selector',
											showlabel: $pparams->showlabel,
											labeltext: '$pparams->labeltext',
											screenreaderIcon: '$pparams->screenreader_icon',
											screenreader: $pparams->screenreader,
											highcontrast: $pparams->highcontrast,
											highcontrastAlternate: $pparams->highcontrast_alternate,
											colorHue: $pparams->highcontrast_alternate_color_hue,
											colorBrightness: $pparams->highcontrast_alternate_color_brightness,
											rootTarget: $pparams->highcontrast_root_target,
											dyslexicFont: $pparams->dyslexic_font,
											grayHues: $pparams->gray_hues,
											spacingSize: $pparams->spacing_size,
											spacingSizeMin: $pparams->spacing_size_min,
											spacingSizeMax: $pparams->spacing_size_max,
											bigCursor: $pparams->big_cursor,
											fontsizeMinimizedToolbar: $pparams->fontsize_minimized_toolbar,
											fontsize: $pparams->fontsize,
											fontsizeDefault: $pparams->font_size_default,
											fontsizeMin: $pparams->font_size_min,
											fontsizeMax: $pparams->font_size_max,
											fontsizeSelector: '$pparams->fontsize_selector',
											fontSizeHeadersIncrement: $pparams->fontsize_headers_increment,
											toolbarBgcolor: '$pparams->toolbar_bgcolor',
											template: '$pparams->template',
											templateOrientation: '$pparams->template_orientation',
											accesskey_play: '$pparams->accesskey_play',
											accesskey_pause: '$pparams->accesskey_pause',
											accesskey_stop: '$pparams->accesskey_stop',
											accesskey_increase: '$pparams->accesskey_increase',
											accesskey_decrease: '$pparams->accesskey_decrease',
											accesskey_reset: '$pparams->accesskey_reset',
											accesskey_highcontrast: '$pparams->accesskey_highcontrast',
											accesskey_highcontrast2: '$pparams->accesskey_highcontrast2',
											accesskey_highcontrast3: '$pparams->accesskey_highcontrast3',
											accesskey_dyslexic: '$pparams->accesskey_dyslexicfont',
											accesskey_grayhues: '$pparams->accesskey_grayhues',
											accesskey_spacingsize_increase: '$pparams->accesskey_spacingsize_increase',
											accesskey_spacingsize_decrease: '$pparams->accesskey_spacingsize_decrease',
											accesskey_bigcursor: '$pparams->accesskey_bigcursor',
											accesskey_skiptocontents: '$pparams->accesskey_skiptocontents',
											accesskey_minimized: '$pparams->accesskey_minimized',
											volume_accesskeys: $pparams->volume_accesskeys,
											readerEngine: '$pparams->reader_engine',
											useMobileReaderEngine: $pparams->use_mobile_reader_engine,
											mobileReaderEngine: '$pparams->mobile_reader_engine',
											proxyResponsiveApikey: '$pparams->proxy_responsive_apikey',
											hideOnMobile: $pparams->hide_on_mobile,
											useMinimizedToolbar: $pparams->use_minimized_toolbar,
											statusMinimizedToolbar: '$pparams->status_minimized_toolbar',
											minimizedToolbarOnlyMobile: $pparams->minimized_toolbar_only_mobile,
											showSkipToContents: $pparams->show_skip_to_contents,
											skipToContentsSelector: '$pparams->skiptocontents_selector',
											removeLinksTarget: $pparams->remove_links_target,
											resetButtonBehavior: '$pparams->reset_button_behavior'
										};
	</script>
JS;
	echo $jsInject;
}

// Now we set that function up to execute when the admin_notices action is called 
add_action( 'wp_head', 'screenreader' );  

function screenreader_install() {
	global $wpdb, $table_prefix;
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	
	$sqlCreateConfigTable = "DROP TABLE IF EXISTS `" . $table_prefix . "screenreader_config`;
	CREATE TABLE IF NOT EXISTS `" . $table_prefix . "screenreader_config` (
		`id` int(11) NOT NULL DEFAULT 1 PRIMARY KEY,
		`volume_tts` int(11) NOT NULL DEFAULT 80,
		`voice_speed` varchar(255) NOT NULL DEFAULT 'normal',
		`read_page` tinyint(4) NOT NULL DEFAULT 1,
		`read_child_nodes` tinyint(4) NOT NULL DEFAULT 1,
		`exclude_scripts` tinyint(4) NOT NULL DEFAULT 1,
		`read_images` tinyint(4) NOT NULL DEFAULT 0,
		`read_images_ordering` varchar(255) NOT NULL DEFAULT 'before',
		`read_images_hovering` tinyint(4) NOT NULL DEFAULT 0,
		`read_images_attribute` varchar(255) NOT NULL DEFAULT 'alt',
		`mainpage_selector` varchar(255) NOT NULL DEFAULT '*[name*=main], *[class*=main], *[id*=main]',
		`select_mainpagearea_text` tinyint(4) NOT NULL DEFAULT 0,
		`chunksize` int(11) NOT NULL DEFAULT 300,
		`gtranslateintegration` tinyint(4) NOT NULL DEFAULT 0,
		`showlabel` tinyint(4) NOT NULL DEFAULT 1,
		`labeltext` varchar(255) NOT NULL DEFAULT 'Screen Reader',
		`labelwidth` int(11) NOT NULL DEFAULT 80,
		`screenreader` tinyint(4) NOT NULL DEFAULT 1,
		`screenreader_icon` varchar(255) NOT NULL DEFAULT 'audio',
		`fontsize` tinyint(4) NOT NULL DEFAULT 1,
		`font_size_default` int(11) NOT NULL DEFAULT 100,
		`font_size_min` int(11) NOT NULL DEFAULT 50,
		`font_size_max` int(11) NOT NULL DEFAULT 200,
		`fontsize_selector` varchar(255) NOT NULL DEFAULT '',
		`fontsize_headers_increment` int(11) NOT NULL DEFAULT 20,
		`highcontrast` tinyint(4) NOT NULL DEFAULT 1,
		`highcontrast_alternate` tinyint(4) NOT NULL DEFAULT 1,
		`highcontrast_alternate_color_hue` int(11) NOT NULL DEFAULT 180,
		`highcontrast_alternate_color_brightness` int(11) NOT NULL DEFAULT 6,
		`highcontrast_root_target` tinyint(4) NOT NULL DEFAULT 0,
	 	`dyslexic_font` tinyint(4) NOT NULL DEFAULT 1,
		`gray_hues` tinyint(4) NOT NULL DEFAULT 0,
		`spacing_size` tinyint(4) NOT NULL DEFAULT 0,
		`spacing_size_min` int(11) NOT NULL DEFAULT 0,
		`spacing_size_max` int(11) NOT NULL DEFAULT 10,
		`big_cursor` tinyint(4) NOT NULL DEFAULT 0,
		`corner_position` varchar(255) NOT NULL DEFAULT 'bottomright',
		`template` varchar(255) NOT NULL DEFAULT 'elegant.css',
		`template_orientation` varchar(255) NOT NULL DEFAULT 'horizontal',
		`toolbar_bgcolor` varchar(255) NOT NULL DEFAULT '#EEE',
		`toolbar_border_radius` int(11) NOT NULL DEFAULT 0,
		`scrolling` varchar(255) NOT NULL DEFAULT 'fixed',
		`target_appendto` varchar(255) NOT NULL DEFAULT 'html',
		`target_append_mode` varchar(255) NOT NULL DEFAULT 'bottom',
		`use_minimized_toolbar` tinyint(4) NOT NULL DEFAULT 0,
		`status_minimized_toolbar` varchar(255) NOT NULL DEFAULT 'closed',
		`minimized_toolbar_only_mobile` tinyint(4) NOT NULL DEFAULT 0,
		`fontsize_minimized_toolbar` tinyint(4) NOT NULL DEFAULT 0,
		`hide_on_mobile` tinyint(4) NOT NULL DEFAULT 0,
		`show_skip_to_contents` tinyint(4) NOT NULL DEFAULT 0,
		`skiptocontents_selector` varchar(255) NOT NULL DEFAULT '',
		`enable_focus_outline` tinyint(4) NOT NULL DEFAULT 0,
		`enable_focus_outline_color` varchar(255) NOT NULL DEFAULT '#F00',
		`enable_focus_outline_bordersize` varchar(255) NOT NULL DEFAULT '2px',
		`remove_links_target` tinyint(4) NOT NULL DEFAULT 0,
		`auto_background_color` tinyint(4) NOT NULL DEFAULT 1,
		`jquery_include` tinyint(4) NOT NULL DEFAULT 1,
		`preload` tinyint(4) NOT NULL DEFAULT 1,
		`ie_highcontrast` tinyint(4) NOT NULL DEFAULT 1,
		`ie_highcontrast_advanced` tinyint(4) NOT NULL DEFAULT 1,
		`selected_storage` varchar(255) NOT NULL DEFAULT 'session',
		`force_jquery_deferred` tinyint(4) NOT NULL DEFAULT 0,
		`script_loading` varchar(255) NOT NULL DEFAULT 'deferred',
		`reset_button_behavior` varchar(255) NOT NULL DEFAULT 'fontsize',
		`sef_lang_code` tinyint(4) NOT NULL DEFAULT 1,
		`reader_engine` varchar(255) NOT NULL DEFAULT 'proxy_responsive',
		`engine_google_token_mode` tinyint(4) NOT NULL DEFAULT 0,
		`reader_connection_usesockets` tinyint(4) NOT NULL DEFAULT 1,
		`use_mobile_reader_engine` tinyint(4) NOT NULL DEFAULT 0,
		`mobile_reader_engine` varchar(255) NOT NULL DEFAULT 'proxy_responsive',
		`proxy_responsive_apikey` varchar(255) NOT NULL DEFAULT 'YkiNlVQr',
		`proxy_responsive_loading_script` tinyint(4) NOT NULL DEFAULT 0,
		`accesskey_play` varchar(255) NOT NULL DEFAULT 'P',
		`accesskey_pause` varchar(255) NOT NULL DEFAULT 'E',
		`accesskey_stop` varchar(255) NOT NULL DEFAULT 'S',
		`accesskey_increase` varchar(255) NOT NULL DEFAULT 'O',
		`accesskey_decrease` varchar(255) NOT NULL DEFAULT 'U',
		`accesskey_reset` varchar(255) NOT NULL DEFAULT 'R',
		`accesskey_highcontrast` varchar(255) NOT NULL DEFAULT 'H',
		`accesskey_highcontrast2` varchar(255) NOT NULL DEFAULT 'J',
		`accesskey_highcontrast3` varchar(255) NOT NULL DEFAULT 'K',
	 	`accesskey_dyslexicfont` varchar(255) NOT NULL DEFAULT 'D',
		`accesskey_grayhues` varchar(255) NOT NULL DEFAULT 'G',
		`accesskey_spacingsize_increase` varchar(255) NOT NULL DEFAULT 'M',
		`accesskey_spacingsize_decrease` varchar(255) NOT NULL DEFAULT 'N',
		`accesskey_bigcursor` varchar(255) NOT NULL DEFAULT 'W',
		`accesskey_skiptocontents` varchar(255) NOT NULL DEFAULT 'C',
		`accesskey_minimized` varchar(255) NOT NULL DEFAULT 'L',
		`volume_accesskeys` tinyint(4) NOT NULL DEFAULT 1
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
	dbDelta($sqlCreateConfigTable);
} 
register_activation_hook(__FILE__,'screenreader_install');
 
function screenreader_install_data() {
	global $wpdb, $table_prefix;  
	$table_name = 'screenreader_config';
	$wpdb->insert( $table_prefix . $table_name, array( 'id' => 1 ));
}
register_activation_hook(__FILE__,'screenreader_install_data'); 

function screenreader_uninstall() {
	global $wpdb, $table_prefix;
	$table_name = 'screenreader_config';
	$wpdb->query( "DROP TABLE " . $table_prefix . $table_name);
}
register_uninstall_hook( __FILE__, 'screenreader_uninstall' );

// ADMIN SECTION
if ( is_admin() )
	require_once dirname( __FILE__ ) . '/admin.php';