<?php 
//namespace wp-content\plugins\screenreader;  
/** 
 * Main wp admin render plugin
 * @package SCREENREADER::plugins
 * @author JExtensions Store 
 * @copyright (C) 2016 - JExtensions Store
 * @license GNU/GPLv2 http://www.gnu.org/licenses/gpl-2.0.html  
 */

// Aggiunge il link settings
function screenreader_plugin_action_links($links, $file) {
	if ($file == plugin_basename ( dirname ( __FILE__ ) . '/screenreader.php' )) {
		$links [] = '<a href="admin.php?page=screenreader-key-config">' . __ ( 'Settings' ) . '</a>';
	}
	
	return $links;
}
add_filter ( 'plugin_action_links', 'screenreader_plugin_action_links', 10, 2 );

// Renderizza il form di configurazione e salva i dati sul DB
function screenreader_conf() {
	global $wpdb, $table_prefix;
	
	// Update DB section
	$query = "SHOW COLUMNS FROM `" . $table_prefix . "screenreader_config`;";
	$columns = $wpdb->get_col( $query );
	
	// Update on 3.28
	if(!in_array('minimized_toolbar_only_mobile', $columns)) {
		$query = "ALTER TABLE `" . $table_prefix . "screenreader_config` ADD `minimized_toolbar_only_mobile` tinyint(4) NOT NULL DEFAULT 0 AFTER `status_minimized_toolbar`;";
		$wpdb->query( $query );
		$query = "ALTER TABLE `" . $table_prefix . "screenreader_config` ADD `spacing_size_min` int(11) NOT NULL DEFAULT 0 AFTER `spacing_size`;";
		$wpdb->query( $query );
		$query = "ALTER TABLE `" . $table_prefix . "screenreader_config` ADD `spacing_size_max` int(11) NOT NULL DEFAULT 10 AFTER `spacing_size_min`;";
		$wpdb->query( $query );
		$query = "ALTER TABLE `" . $table_prefix . "screenreader_config` ADD `gtranslateintegration` tinyint(4) NOT NULL DEFAULT 0 AFTER `chunksize`;";
		$wpdb->query( $query );
		$query = "ALTER TABLE `" . $table_prefix . "screenreader_config` ADD `highcontrast_root_target` tinyint(4) NOT NULL DEFAULT 0 AFTER `highcontrast_alternate_color_brightness`;";
		$wpdb->query( $query );
		$query = "ALTER TABLE `" . $table_prefix . "screenreader_config` ADD `fontsize_minimized_toolbar` tinyint(4) NOT NULL DEFAULT 0 AFTER `minimized_toolbar_only_mobile`;";
		$wpdb->query( $query );
	}
	
	// Live Site
	$siteUrl = plugins_url('/', __FILE__); 
	// CONFIG LOAD DA DB OPTIONS
	$screenreaderQuery = "SELECT * FROM " . $table_prefix . "screenreader_config";
	$screenreaderConfig = $wpdb->get_row($screenreaderQuery);
 
	// Save config da POST submit
	if ( isset($_POST['submit']) ) {
		$fields = array();
		foreach ($screenreaderConfig as $paramName=>&$paramValue) {
			$paramValue = $_POST[$paramName];
			$fields[$paramName] = $paramValue;
		} 
		if($wpdb->update($table_prefix . 'screenreader_config', $fields, array('id'=>1))) {
			echo '<div id="message" class="updated"><p>Settings saved</p></div>'; 
		} else {
			echo '<div id="message" class="updated"><p>Settings up-to-date</p></div>'; 
		}
	}
	 
	// Config form generation
	if(is_object($screenreaderConfig)) {
		$config = null;
		foreach ($screenreaderConfig as $paramNameForm=>$paramValueForm) {
			switch($paramNameForm) {
				case 'volume_tts':
					$config .= "<div style='min-height:40px;'><label style='float:left;font-weight:bold;font-size:21px;text-decoration:underline'>Main settings</label></div>";
					break;
				case 'showlabel':
					$config .= "<div style='min-height:40px;'><label style='float:left;font-weight:bold;font-size:21px;text-decoration:underline'>Appearance</label></div>";
					break;			
				case 'show_skip_to_contents':
					$config .= "<div style='min-height:40px;'><label style='float:left;font-weight:bold;font-size:21px;text-decoration:underline'>Accessibility improvements</label></div>";
					break;
				case 'auto_background_color':
					$config .= "<div style='min-height:40px;'><label style='float:left;font-weight:bold;font-size:21px;text-decoration:underline'>Advanced settings</label></div>";
					break;
				case 'accesskey_play':
					$config .= "<div style='min-height:40px;'><label style='float:left;font-weight:bold;font-size:21px;text-decoration:underline'>Accesskeys</label></div>";
					break;
			}
			
			$labelValues = screenreaderTransformFunctionLabel($paramNameForm);
			$config .= "<div style='min-height:40px;'><label title='" . $labelValues[1] . "' style='float:left;width:240px'>" . $labelValues[0] . "</label>";
			$config .= screenreaderTransformFunctionInput($paramNameForm, $paramValueForm);
			$config .= "</div>";
		} 
	} 
	?>
<fieldset
	style="border: 1px solid #CCC; padding: 20px; margin-top: 30px;">
	<legend style="width: 580px;">
		<img src="<?php echo $siteUrl;?>config_icon.png" alt="config_icon" />
		<label style="font-weight: bold; margin-top: 50px; display: block; float: right; font-size: 24px;">Screen Reader settings and configuration</label>
	</legend>
	<form action="" method="post" id="screenreader-conf">
		<input style='float:right;width:150px;background-color:#23282D;color:#FFF;border:none;cursor:pointer;padding:5px 10px;line-height:inherit' type="submit" name="submit" value="<?php _e('Save settings'); ?>" /> 
			<?php echo $config;?>
		</form>
</fieldset>
<?php
}
  
function screenreader_load_menu() { 
	add_submenu_page ( 'plugins.php', __ ( 'Screen Reader settings' ), __ ( 'Screen Reader settings' ), 'manage_options', 'screenreader-key-config', 'screenreader_conf' ); 
}
add_action ( 'admin_menu', 'screenreader_load_menu' ); 

function screenreader_enqueue_color_picker( $hook_suffix ) {
	// first check that $hook_suffix is appropriate for your admin page
	wp_enqueue_style( 'wp-color-picker' );
	wp_enqueue_script( 'my-script-handle', plugins_url('libraries/jquery/colorpicker.js', __FILE__ ), array( 'wp-color-picker' ), false, true );
}
add_action( 'admin_enqueue_scripts', 'screenreader_enqueue_color_picker' );

/**
 * Funzione di trasformazione HTML controls, restituisce il controllo richiesto
 * @param string $control
 * @param mixed $value
 * @return string
 */
function screenreaderTransformFunctionInput($control, $value) {
	// Text translations
	static $adminLanguageStrings = null;
	if(!$adminLanguageStrings) {
		$adminLanguageFile = dirname(__FILE__) . "/languages/admin/en-GB.ini";
		if(file_exists($adminLanguageFile)) {
			$adminLanguageStrings = parse_ini_file($adminLanguageFile, false, INI_SCANNER_NORMAL);
		}
	}
	
	// Main switch
	switch ($control) {
		case 'volume_tts' :
			$options = array(20=>'20%',40=>'40%',60=>'60%',80=>'80%',100=>'100%');
			$str = '<select name="volume_tts">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'voice_speed' :
			$options = array('veryslow'=>'VOICE_SPEED_VERYSLOW','slow'=>'VOICE_SPEED_SLOW','normal'=>'VOICE_SPEED_NORMAL','fast'=>'VOICE_SPEED_FAST','veryfast'=>'VOICE_SPEED_VERYFAST');
			$str = '<select name="voice_speed">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'read_page' :
			$options = array(0=>'SELECTED_TEXT_ONLY', 1=>'MAINPAGE_PART_AND_SELECTED_TEXT');
			$str = '<select name="read_page">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'read_images_attribute' :
			$options = array('alt'=>'ALT', 'title'=>'TITLE');
			$str = '<select name="read_images_attribute">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;

		case 'read_images_ordering' :
			$options = array('before'=>'BEFORE', 'after'=>'AFTER');
			$str = '<select name="read_images_ordering">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
		
		case 'chunksize':
			$options = array (
					'20' => '20',
					'40' => '40',
					'60' => '60',
					'80' => '80',
					'90' => '90',
					'100'=>'100',
					'120' => '120',
					'140' => '140',
					'160' => '160',
					'180' => '180',
					'200' => '200',
					'220' => '220',
					'240' => '240',
					'260' => '260',
					'280' => '280',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600'=>'600',
					'700' => '700',
					'800' => '800',
					'900'=>'900',
					'1000'=>'1000');
			$str = '<select name="chunksize">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'highcontrast_alternate_color_hue' :
			$options = array(45=>'FONTSIZE_VERYLOW',
							 90=>'FONTSIZE_LOW',
							 180=>'FONTSIZE_MEDIUM',
							 225=>'FONTSIZE_AVERAGE',
							 270=>'FONTSIZE_HIGH',
							 305=>'FONTSIZE_VERYHIGH');
			$str = '<select name="highcontrast_alternate_color_hue">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'highcontrast_alternate_color_brightness' :
			$options = array(2=>'FONTSIZE_VERYLOW',
							 4=>'FONTSIZE_LOW',
							 6=>'FONTSIZE_AVERAGE',
							 8=>'FONTSIZE_HIGH',
							 10=>'FONTSIZE_VERYHIGH');
			$str = '<select name="highcontrast_alternate_color_brightness">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
				
		case 'fontsize_selector_mode' :
			$options = array(0=>'APPEND', 1=>'OVERRIDE');
			$str = '<select name="fontsize_selector_mode">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
				
		case 'corner_position' :
			$options = array('topright'=>'TOP_RIGHT',
							 'bottomright'=>'BOTTOM_RIGHT',
							 'topleft'=>'TOP_LEFT',
							 'bottomleft'=>'BOTTOM_LEFT');
			$str = '<select name="corner_position">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'template' :
			$options = array('main.css'=>'MAIN_TEMPLATE',
							 'elegant.css'=>'ELEGANT_TEMPLATE',
							 'awesome.css'=>'AWESOME_TEMPLATE',
							 'custom.css'=>'CUSTOM_TEMPLATE');
			$str = '<select name="template">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'template_orientation' :
			$options = array('horizontal'=>'ORIENTATION_HORIZONTAL',
							 'vertical'=>'ORIENTATION_VERTICAL');
			$str = '<select name="template_orientation">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'screenreader_icon' :
			$options = array('audio'=>'SCREENREADER_ICON_AUDIO',
							 'wheelchair'=>'SCREENREADER_ICON_WHEELCHAIR');
			$str = '<select name="screenreader_icon">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
				
		case 'scrolling' :
			$options = array('fixed'=>'FIXED_IMAGE',
							 'absolute'=>'SCROLLING_IMAGE',
							 'relative'=>'RELATIVE_IMAGE');
			$str = '<select name="scrolling">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
				
		case 'target_append_mode' :
			$options = array('top'=>'TARGET_APPEND_MODE_TOP',
							 'bottom'=>'TARGET_APPEND_MODE_BOTTOM');
			$str = '<select name="target_append_mode">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'script_loading' :
			$options = array('deferred'=>'SCRIPT_LOADING_DEFERRED',
							 'dom'=>'SCRIPT_LOADING_DOM');
			$str = '<select name="script_loading">' .screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
				
		case 'reader_engine' :
			$options = array('proxy_responsive'=>'READER_ENGINE_RESPONSIVEVOICE',
							 'proxy'=>'READER_ENGINE_GOOGLE',
							 'proxy_ispeech'=>'READER_ENGINE_ISPEECH',
							 'proxy_inforobo'=>'READER_ENGINE_INFOROBO',
							 'proxy_virtual_free'=>'READER_ENGINE_VIRTUALSPEAKER_FREE',
							 'proxy_texttomp3'=>'READER_ENGINE_TEXTTOMP3',
							 'proxy_ttsmp3'=>'READER_ENGINE_TTSMP3');
			$str = '<select name="reader_engine">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'mobile_reader_engine' :
			$options = array('proxy_responsive'=>'READER_ENGINE_RESPONSIVEVOICE',
							 'proxy'=>'READER_ENGINE_GOOGLE',
							 'proxy_ispeech'=>'READER_ENGINE_ISPEECH',
							 'proxy_inforobo'=>'READER_ENGINE_INFOROBO',
							 'proxy_virtual_free'=>'READER_ENGINE_VIRTUALSPEAKER_FREE',
							 'proxy_texttomp3'=>'READER_ENGINE_TEXTTOMP3',
							 'proxy_ttsmp3'=>'READER_ENGINE_TTSMP3');
			$str = '<select name="mobile_reader_engine">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
		
		case 'proxy_responsive_loading_script' :
			$options = array(0=>'PROXY_RESPONSIVE_LOADING_SCRIPT_LOCAL',
							 1=>'PROXY_RESPONSIVE_LOADING_SCRIPT_REMOTE');
			$str = '<select name="proxy_responsive_loading_script">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'enable_focus_outline_bordersize':
			$options = array('1px'=>'FOCUS_OUTLINE_BORDER_SIZE_1PX',
							 '2px'=>'FOCUS_OUTLINE_BORDER_SIZE_2PX',
							 '3px'=>'FOCUS_OUTLINE_BORDER_SIZE_3PX',
							 '4px'=>'FOCUS_OUTLINE_BORDER_SIZE_4PX');
			$str = '<select name="enable_focus_outline_bordersize">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
		
		case 'toolbar_bgcolor':
			$str = "<input type='text' value='" . $value . "' name='toolbar_bgcolor' class='my-color-field' data-default-color='#EEE'/>";
			break;
			
		case 'enable_focus_outline_color':
			$str = "<input type='text' value='" . $value . "' name='enable_focus_outline_color' class='my-color-field' data-default-color='#F00'/>";
			break;
			
		case 'engine_google_token_mode':
			$options = array(0=>'READER_ENGINE_GOOGLE_STATIC',
							 1=>'READER_ENGINE_GOOGLE_DYNAMIC');
			$str = '<select name="engine_google_token_mode">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'reset_button_behavior':
			$options = array('fontsize'=>'RESET_BUTTON_BEHAVIOR_FONTSIZE',
							 'all'=>'RESET_BUTTON_BEHAVIOR_ALL');
			$str = '<select name="reset_button_behavior">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
		
		case 'status_minimized_toolbar':
			$options = array('closed'=>'STATUS_MINIMIZED_TOOLBAR_CLOSED',
							 'open'=>'STATUS_MINIMIZED_TOOLBAR_OPEN');
			$str = '<select name="status_minimized_toolbar">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'selected_storage':
			$options = array('session'=>'SELECTED_STORAGE_SESSION',
							 'local'=>'SELECTED_STORAGE_LOCAL');
			$str = '<select name="selected_storage">' . screenreaderGenericSelectLists( $options, $value, $adminLanguageStrings) . '</select>';
			break;
			
		case 'read_child_nodes':
		case 'exclude_scripts':
		case 'read_images':
		case 'read_images_hovering':
		case 'showlabel':
		case 'screenreader':
		case 'fontsize':
		case 'highcontrast':
		case 'highcontrast_alternate':
		case 'dyslexic_font':
		case 'gray_hues':
		case 'spacing_size':
		case 'big_cursor':
		case 'hide_on_mobile':
		case 'use_minimized_toolbar':
		case 'jquery_include':
		case 'preload':
		case 'ie_highcontrast':
		case 'volume_accesskeys':
		case 'ie_highcontrast_advanced':
		case 'select_mainpagearea_text':
		case 'force_jquery_deferred':
		case 'sef_lang_code':
		case 'reader_connection_usesockets':
		case 'use_mobile_reader_engine':
		case 'show_skip_to_contents':
		case 'remove_links_target':
		case 'enable_focus_outline':
		case 'auto_background_color':
		case 'highcontrast_root_target':
		case 'fontsize_minimized_toolbar':
		case 'minimized_toolbar_only_mobile':
		case 'gtranslateintegration':
			$checked = (bool)$value ? 'checked' : '';
			$nochecked = !(bool)$value ? 'checked' : '';
			$str = "<input type='radio' name='$control' $nochecked value='0'/>&nbsp;No";
			$str .= "&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;  <input type='radio' name='$control' $checked value='1'/>&nbsp;Yes";
			break;
			
		case 'id':
			$str = "<input type='hidden' name='id' value='1'/>";
			break;
		default:
			$styles = null;
			if(stripos($control, 'selector')) {
				$styles = "style='width: 50%'";
			}
			$str = "<input type='text' name='$control' value='$value' $styles/>";	
	} 
	return $str;
}

/**
 * Funzione di trasformazione HTML controls, restituisce il controllo richiesto
 * @param string $control 
 * @return array
 */
function screenreaderTransformFunctionLabel($controlName) {
	// Text translations
	static $adminLanguageStrings = null;
	$titleString = null;
	$descriptionString = null;
	
	if(!$adminLanguageStrings) {
		$adminLanguageFile = dirname(__FILE__) . "/languages/admin/en-GB.ini";
		if(file_exists($adminLanguageFile)) {
			$adminLanguageStrings = parse_ini_file($adminLanguageFile, false, INI_SCANNER_NORMAL);
		}
	}
	
	// Manage title + desc
	$titleIdentifier = strtoupper($controlName);
	$descriptionIdentifier = $titleIdentifier . '_DESC';

	if(array_key_exists($titleIdentifier, $adminLanguageStrings)) {
		$titleString = $adminLanguageStrings[$titleIdentifier];
	}
	
	if(array_key_exists($descriptionIdentifier, $adminLanguageStrings)) {
		$descriptionString = htmlspecialchars($adminLanguageStrings[$descriptionIdentifier], ENT_QUOTES, 'UTF-8');
	}

	return array($titleString, $descriptionString);
}


/**
 * Renders a generic dropdown list
 * @param string $type
 * @return array
 */
function screenreaderGenericSelectLists($optionsArray, $value, $languageStrings) {
	$optionsString = null;
	foreach ($optionsArray as $optionValue=>$optionText) {
		if(array_key_exists($optionText, $languageStrings)) {
			$optionText = $languageStrings[$optionText];
		}
		$checked = $optionValue == $value ? 'selected="selected"' : '';
		$optionsString .= '<option ' . $checked . ' value="' . $optionValue . '">' . $optionText . '</option>';
	}
	
	return $optionsString;
}

// Load the TinyMCE addon
add_action( 'admin_print_footer_scripts',  'myplugin_register_tinymce_javascript' );

function myplugin_register_tinymce_javascript() {
	$buttonCode = <<<BUTTON
	<script type="text/javascript">
		if(typeof(jQuery) !== 'undefined') {
			jQuery(function($){
				setTimeout(function(){
					if($('#wp-content-editor-tools, div[role=toolbar]').length) {
						window.scrInsertPlayBtn = function() {
							var activeEditor = null;
							if(typeof(tinyMCE) !== 'undefined') {
								activeEditor = tinyMCE.activeEditor;
							} else if(typeof(tinymce) !== 'undefined') {
								activeEditor = tinymce.activeEditor;
							}
							if(activeEditor && $('div.mce-edit-focus').length) {
								activeEditor.execCommand('mceInsertContent', false, codeToAdd);
								setTimeout(function(){
									$('div.mce-edit-focus').blur();
								},100);
							} else {
								$('p.block-editor-rich-text__editable.is-selected[role=textbox]').append(codeToAdd);
							}
							return false;
						};
						var codeToAdd = '<span class="screenreader_embed_play_button"> {Play}</span>';
						var codeToAppend = '<div class="wp-media-buttons"><button class="button" onclick="window.scrInsertPlayBtn();return false;"><span style="font: 400 18px/1 dashicons;vertical-align: text-top;color: #82878c;" class="dashicons-video-alt3"></span> ScreenReader Play</button></div>';
						$('#wp-content-editor-tools, div[role=toolbar]').append(codeToAppend);
					};
				},1);
			});
		};
	</script>
BUTTON;

	echo $buttonCode;
}