<?php

/*
* Add your own functions here. You can also copy some of the theme functions into this file.
* Wordpress will use those functions instead of the original functions then.
*/



// Ajout Google Font

function add_google_fonts() {
  wp_enqueue_style( ' add_google_fonts ', 'https://fonts.googleapis.com/css2?family=Montserrat+Alternates:wght@500;700&family=Montserrat:wght@400;700&display=swap', false );
}

add_action( 'wp_enqueue_scripts', 'add_google_fonts' );


// Ajout JS personnalisé

function add_cfas() {

  wp_enqueue_script(
      'enrollware-script',
      get_stylesheet_directory_uri().'/cfas.js',
      array('jquery')
  );

}

add_action( 'wp_enqueue_scripts', 'add_cfas' );



// Désactivation AdminBar
show_admin_bar(false);

// Moteur recherche Header
add_shortcode('avia_search', 'get_search_form');

add_filter('avf_frontend_search_form_param', 'avia_deactivate_ajax_search',10,1);
function avia_deactivate_ajax_search($params)
{
	$params['ajax_disable'] = true;
	return $params;
}




// Désactivation des commentaires
add_action('admin_init', function () {
    // Redirect any user trying to access comments page
    global $pagenow;

    if ($pagenow === 'edit-comments.php') {
        wp_redirect(admin_url());
        exit;
    }

    // Remove comments metabox from dashboard
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');

    // Disable support for comments and trackbacks in post types
    foreach (get_post_types() as $post_type) {
        if (post_type_supports($post_type, 'comments')) {
            remove_post_type_support($post_type, 'comments');
            remove_post_type_support($post_type, 'trackbacks');
        }
    }
});

// Close comments on the front-end
add_filter('comments_open', '__return_false', 20, 2);
add_filter('pings_open', '__return_false', 20, 2);

// Hide existing comments
add_filter('comments_array', '__return_empty_array', 10, 2);

// Remove comments page in menu
add_action('admin_menu', function () {
    remove_menu_page('edit-comments.php');
});

// Remove comments links from admin bar
add_action('init', function () {
    if (is_admin_bar_showing()) {
        remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60);
    }
});
